/*
 * Decompiled with CFR 0.152.
 */
package com.apporchid.drivers.service;

import com.apporchid.drivers.repository.AOPlatformJdbcRepository;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

@Service
public class AOPlatformJDBCService {
    private static final Logger LOGGER = Logger.getLogger(AOPlatformJDBCService.class.getName());
    private static final String LOG_FILE = "results.log";
    private static final String QUERY_MODE = AOPlatformJDBCService.requiredNonEmptySystemProperty((String)"aoplatform.query.mode");
    private static final String MSO_QUERY = AOPlatformJDBCService.requiredNonEmptySystemProperty((String)"aoplatform.msoQuery");
    private final AOPlatformJdbcRepository repository;

    public AOPlatformJDBCService(AOPlatformJdbcRepository repository) {
        this.repository = repository;
    }

    private static String requiredNonEmptySystemProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)String.format("System property %s must be non-empty", propertyName));
        return value;
    }

    public boolean runQuery() {
        return this.runQuery(MSO_QUERY, LOG_FILE);
    }

    public boolean runQuery(String query, String logFile) {
        if ("MSO".equalsIgnoreCase(QUERY_MODE)) {
            return this.runMsoQuery(query, logFile);
        }
        return this.runEaQuery(query, logFile);
    }

    private boolean runMsoQuery(String query, String logFile) {
        boolean bl;
        block8: {
            Stream rowStream = this.repository.streamMsoQuery(query);
            try {
                this.writeStreamToLogFile(rowStream, logFile + "_MSO");
                bl = true;
                if (rowStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rowStream != null) {
                        try {
                            rowStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "MSO Query operation failed.", e);
                    return false;
                }
            }
            rowStream.close();
        }
        return bl;
    }

    private boolean runEaQuery(String query, String logFile) {
        boolean bl;
        block8: {
            Stream rowStream = this.repository.streamEaQuery(query);
            try {
                this.writeStreamToLogFile(rowStream, logFile + "_EA");
                bl = true;
                if (rowStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rowStream != null) {
                        try {
                            rowStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "EA Query operation failed.", e);
                    return false;
                }
            }
            rowStream.close();
        }
        return bl;
    }

    private void writeStreamToLogFile(Stream<Map<String, Object>> rowStream, String logFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter("results/" + logFile);){
            rowStream.forEach(row -> {
                try {
                    fileWriter.write(row.toString());
                    fileWriter.write("\n");
                }
                catch (IOException e) {
                    throw new RuntimeException("Error writing row to file", e);
                }
            });
            LOGGER.info("\n==============================\nResults written to log file: " + logFile + "\n==============================");
        }
    }
}

