/*
 * Decompiled with CFR 0.152.
 */
package com.apporchid.drivers.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configuration
public class AvaticaDataSourceConfig {
    private static String requiredNonEmptySystemProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)String.format("System property %s must be non-empty", propertyName));
        return value;
    }

    @Bean
    public DataSource avaticaDataSource() {
        String jdbcUrl = AvaticaDataSourceConfig.requiredNonEmptySystemProperty("aoplatform.test.server.url");
        String schema = AvaticaDataSourceConfig.requiredNonEmptySystemProperty("aoplatform.schema.name");
        String user = AvaticaDataSourceConfig.requiredNonEmptySystemProperty("aoplatform.test.server.user");
        String password = AvaticaDataSourceConfig.requiredNonEmptySystemProperty("aoplatform.test.server.password");
        String queryMode = AvaticaDataSourceConfig.requiredNonEmptySystemProperty("aoplatform.query.mode");
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.apache.calcite.avatica.remote.Driver");
        dataSource.setUrl(jdbcUrl);
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        Properties connectionProps = new Properties();
        connectionProps.setProperty("SCHEMA", schema);
        connectionProps.setProperty("QUERY_MODE", queryMode);
        dataSource.setConnectionProperties(connectionProps);
        return dataSource;
    }

    @Bean
    public JdbcTemplate avaticaJdbcTemplate(DataSource avaticaDataSource) {
        return new JdbcTemplate(avaticaDataSource);
    }
}

