/*
 * Decompiled with CFR 0.152.
 */
package com.apporchid.drivers.repository;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class AOPlatformJdbcRepository {
    private static final Logger LOGGER = Logger.getLogger(AOPlatformJdbcRepository.class.getName());
    private final JdbcTemplate jdbcTemplate;

    public AOPlatformJdbcRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Stream<Map<String, Object>> streamMsoQuery(String query) {
        LOGGER.log(Level.INFO, "Executing MSO query in streaming mode: {0}", query);
        return this.jdbcTemplate.queryForStream(query, (RowMapper)new ColumnMapRowMapper());
    }

    public Stream<Map<String, Object>> streamEaQuery(String query) {
        LOGGER.log(Level.INFO, "Executing EA query in streaming mode: {0}", query);
        return this.jdbcTemplate.queryForStream(query, (RowMapper)new ColumnMapRowMapper());
    }
}

