package com.apporchid.drivers.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

import javax.sql.DataSource;
import java.util.Properties;

@Configuration
public class AvaticaDataSourceConfig {

    private static String requiredNonEmptySystemProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(value),
                String.format("System property %s must be non-empty", propertyName));
        return value;
    }

    @Bean
    public DataSource avaticaDataSource() {
        String jdbcUrl = requiredNonEmptySystemProperty("aoplatform.test.server.url");
        String schema = requiredNonEmptySystemProperty("aoplatform.schema.name");
        String user = requiredNonEmptySystemProperty("aoplatform.test.server.user");
        String password = requiredNonEmptySystemProperty("aoplatform.test.server.password");
        String queryMode = requiredNonEmptySystemProperty("aoplatform.query.mode");

        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.apache.calcite.avatica.remote.Driver");
        dataSource.setUrl(jdbcUrl);
        dataSource.setUsername(user);
        dataSource.setPassword(password);

        // Additional Avatica-specific props
        Properties connectionProps = new Properties();
        connectionProps.setProperty("SCHEMA", schema);
        connectionProps.setProperty("QUERY_MODE", queryMode);

        dataSource.setConnectionProperties(connectionProps);

        return dataSource;
    }

    @Bean
    public JdbcTemplate avaticaJdbcTemplate(DataSource avaticaDataSource) {
        return new JdbcTemplate(avaticaDataSource);
    }

}
