package com.apporchid.drivers.utilityai;

import com.apporchid.drivers.BaselatformIntegrationTest;
import com.apporchid.drivers.service.AOPlatformJDBCService;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

/**
 * Integration test that starts the entire Spring context.
 * Requires real system properties, or you can set them in @BeforeAll.
 * <p>
 * If you have a running Avatica endpoint, the test will attempt to connect
 * and run a real query. If you do NOT have a real server available, this might fail.
 */
@SpringBootTest
class EasyAnswersIntegrationTest extends BaselatformIntegrationTest {

    @Autowired
    private AOPlatformJDBCService jdbcService;

    @BeforeAll
    static void setUpSystemProperties() {
        initializeEnvironment("EA", "SHOW ALL Meters");
    }

    @Test
    void testServiceRunQuery() {
        boolean success = jdbcService.runQuery();
        org.junit.jupiter.api.Assertions.assertTrue(success,
                "Expected the query to run successfully against a live Avatica server");
    }

}
