package com.apporchid.drivers;

import com.google.common.base.Preconditions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
@Execution(ExecutionMode.CONCURRENT)
public abstract class AbstractTestQueryFramework {

    private AOPlatformJDBCExample queryRunner;

    protected abstract AOPlatformJDBCExample createQueryRunner() throws Exception;

    @BeforeAll
    public void init() throws Exception {
        this.queryRunner = this.createQueryRunner();
    }

    protected AOPlatformJDBCExample getQueryRunner() {
        Preconditions.checkNotNull(queryRunner);
        return queryRunner;
    }

}
