package com.apporchid.drivers.ea;

import com.apporchid.drivers.AOPlatformJDBCExample;
import com.apporchid.drivers.AbstractTestQueryFramework;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import static com.apporchid.drivers.Constants.PASSWORD;

class UtilityAIEAPlatformQueryRunner extends AbstractTestQueryFramework {

    @Override
    protected AOPlatformJDBCExample createQueryRunner() throws Exception {
        System.setProperty("aoplatform.test.server.url", "jdbc:avatica:remote:url=http://localhost:8765");
        System.setProperty("aoplatform.test.server.user", "admin");
        System.setProperty("aoplatform.test.server.password", PASSWORD);
        System.setProperty("aoplatform.schema.name", "UT");
        System.setProperty("aoplatform.query.mode", "EA");
        System.setProperty("aoplatform.msoQuery", "show all meters");

        return new AOPlatformJDBCExample();
    }

    @Test
    void execute_meter_query() {
        Assertions.assertTrue(getQueryRunner().runQuery());
    }

    @Test
    void execute_customer_query() {
        Assertions.assertTrue(getQueryRunner().runQuery("show all Customers limit 10", "Customer"), "customer data is processed");
    }

    @Test
    void execute_bills_query() {
        Assertions.assertTrue(getQueryRunner().runQuery("Show all Bills ", "Bills"), "bills data is processed");
    }

}
