package com.apporchid.drivers.mso;

import com.apporchid.drivers.AOPlatformJDBCExample;
import com.apporchid.drivers.AbstractTestQueryFramework;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import static com.apporchid.drivers.Constants.PASSWORD;

class UtilityAIPlatformQueryRunner extends AbstractTestQueryFramework {

    @Override
    protected AOPlatformJDBCExample createQueryRunner() throws Exception {
        System.setProperty("aoplatform.test.server.url", "jdbc:avatica:remote:url=http://localhost:8765");
        System.setProperty("aoplatform.test.server.user", "admin");
        System.setProperty("aoplatform.test.server.password", PASSWORD);
        System.setProperty("aoplatform.schema.name", "UT");
        System.setProperty("aoplatform.query.mode", "MSO");
        System.setProperty("aoplatform.msoQuery", "select * from Meter t0 limit 10");

        return new AOPlatformJDBCExample();
    }

    @Test
    void execute_meter_query() {
        Assertions.assertTrue(getQueryRunner().runQuery());
    }

    @Test
    void execute_customer_query() {
        Assertions.assertTrue(getQueryRunner().runQuery("select * from Customer t0 limit 10", "Customer"), "customer data is processed");
    }

    @Test
    void execute_bills_query() {
        Assertions.assertTrue(getQueryRunner().runQuery("select * from Bills t0 limit 10", "Bills"), "bills data is processed");
    }

}
